/*
 * *************************************************************************************************
 *                                 Copyright 2018 Universum Studios
 * *************************************************************************************************
 *                  Licensed under the Apache License, Version 2.0 (the "License")
 * -------------------------------------------------------------------------------------------------
 * You may not use this file except in compliance with the License. You may obtain a copy of the
 * License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * *************************************************************************************************
 */
package universum.studios.android.arkhitekton.interaction.usecase

import android.support.annotation.NonNull
import universum.studios.android.arkhitekton.interaction.Response
import universum.studios.android.arkhitekton.util.Failure

/**
 * Interface describing a response which is returned by [UseCase] as result of its execution via
 * [UseCase.execute].
 *
 * @param Result Type of the result that this response can provide as result of processed request via [getResult].
 *
 * @author Martin Albedinsky
 * @since 1.0
 *
 * @see UseCaseRequest
 */
@Deprecated("Use Response instead!", replaceWith = ReplaceWith("Response"))
interface UseCaseResponse<out Result> : Response<Result> {

    /*
     * Companion ===================================================================================
     */

    /**
     * Contract for [UseCaseResponse] element.
     */
    companion object Contract

    /*
	 * Interface ===================================================================================
	 */

    /**
     * Basic interface for factory which may be used to create instances of [UseCaseResponse].
     *
     * @author Martin Albedinsky
     * @since 1.0
     */
    @Deprecated("Use Response.Factory instead!", replaceWith = ReplaceWith("Response"))
    interface Factory {

        /**
         * Creates a new instance of successful use case response with the specified `result`.
         *
         * @param request  Request for which is the response being created.
         * @param result   Result of the processed request.
         * @param Result Type of the response result.
         * @return Use case response ready to be dispatched.
         *
         * @see createFailure
         */
        @NonNull fun <Result> createSuccess(@NonNull request: UseCaseRequest, @NonNull result: Result): UseCaseResponse<Result>

        /**
         * Creates a new instance of use case response which represents a failure.
         *
         * @param request  Request for which is the response being created.
         * @param failure  Failure due to which processing of the request has failed.
         * @param Result Type of the response result.
         * @return Use case response ready to be dispatched.
         *
         * @see createSuccess
         */
        @NonNull fun <Result> createFailure(@NonNull request: UseCaseRequest, @NonNull failure: Failure): UseCaseResponse<Result>
    }

    /*
     * Functions ===================================================================================
     */
}