/*
 * =================================================================================================
 *                             Copyright (C) 2018 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License
 * you may obtain at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * You can redistribute, modify or publish any part of the code written within this file but as it
 * is described in the License, the software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.arkhitekton.view

import android.support.annotation.NonNull

/**
 * Interface declaring layer for view models that are used across application in order to persist
 * state for [Views][View].
 *
 * **Note that it is recommended to not directly implement this interface as its signature may
 * change over time, but rather to inherit from its [BaseViewModel] implementation.**
 *
 * @author Martin Albedinsky
 * @since 1.0
 */
interface ViewModel {

    /**
     * Contract for [ViewModel] element.
     */
    companion object Contract {

        /**
         * Empty implementation (NULL object) which doesn't *persist* any view data.
         */
        @NonNull internal val EMPTY: ViewModel = object : ViewModel {}

        /**
         * Returns an empty instance of view model which may be used in cases when a concrete [View]
         * does not need to persist its state.
         *
         * @return Empty view model ready to be used.
         */
        @NonNull fun empty() = EMPTY
    }
}