/*
 * =================================================================================================
 *                             Copyright (C) 2018 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License
 * you may obtain at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * You can redistribute, modify or publish any part of the code written within this file but as it
 * is described in the License, the software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.arkhitekton.interaction.usecase

import android.support.annotation.NonNull

/**
 * Basic interface describing result which is carried by [UseCaseResponse].
 *
 * @author Martin Albedinsky
 * @since 1.0
 *
 * @see UseCaseResponse.getResult
 */
interface UseCaseResult {

    /*
	 * Companion ===================================================================================
	 */

    /**
     * Contract for [UseCaseResult] element.
     */
    companion object Contract {

        /**
         * Empty instance without any data.
         */
        @NonNull internal val EMPTY: Empty = object : Empty {}

        /**
         * Returns an instance of empty result which has no data.
         *
         * @return Empty result ready to be attached to a desired use case response.
         */
        @NonNull fun empty() = EMPTY
    }

    /*
     * Interface ===================================================================================
     */

    /**
     * An [UseCaseResult] extension which may be used to indicate that a particular [UseCaseResponse]
     * will cary an empty result, that is, without any data.
     *
     * @author Martin Albedinsky
     * @since 1.0
     *
     * @see empty
     */
    interface Empty : UseCaseResult

    /*
     * Methods =====================================================================================
     */
}