/*
 * =================================================================================================
 *                             Copyright (C) 2018 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License
 * you may obtain at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * You can redistribute, modify or publish any part of the code written within this file but as it
 * is described in the License, the software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.arkhitekton.view

import android.app.Application
import android.arch.lifecycle.AndroidViewModel
import android.content.Context
import android.content.res.Resources
import android.support.annotation.NonNull

/**
 * A [ViewModel] base implementation which is recommended to be inherited by concrete view model
 * implementations in order to take advantage of already implemented stubs of [ViewModel] interface
 * and also to be 'resistant' against future changes in that interface.
 *
 * **Remember that view model instances are created by the Android architecture components library
 * via reflection, so theirs classes need to be PUBLIC and also to have at least one PUBLIC constructor.**
 *
 * @author Martin Albedinsky
 * @since 1.0
 *
 * @constructor Creates a new instance of BaseViewModel with the specified `application` instance.
 * @param application The application instance which may be used by the view model or its dependants&nbsp;
 * to access application specific components like [Context], [Resources] or system services.
 */
abstract class BaseViewModel(@NonNull application: Application) : AndroidViewModel(application), ViewModel {

    /*
	 * Companion ===================================================================================
	 */

    /**
     */
    companion object {

        /**
         * Log TAG.
         */
        internal const val TAG = "BaseViewModel"
    }

    /*
	 * Interface ===================================================================================
	 */

    /*
     * Members =====================================================================================
     */

    /*
     * Initialization ==============================================================================
     */

    /*
     * Methods =====================================================================================
     */

    /*
     * Inner classes ===============================================================================
     */
}