/*
 * =================================================================================================
 *                             Copyright (C) 2018 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License
 * you may obtain at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * You can redistribute, modify or publish any part of the code written within this file but as it
 * is described in the License, the software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.arkhitekton.util

import android.support.annotation.NonNull

/**
 * Basic interface for builders used to create instances of a desired classes.
 *
 * Builder implementations are allowed to throw an [AssertionError] when [build] is called upon them
 * and there are some required arguments missing for a successful instance build.
 *
 * @param T Type of the class of which instance the builder can build.
 *
 * @author Martin Albedinsky
 * @since 1.0
 */
interface InstanceBuilder<out T> {

    /**
     * Builds a new instance of object specific for this builder.
     *
     * @return New instance ready to be used.
     * @throws AssertionError If some of the required arguments is not specified.
     */
    @NonNull fun build(): T
}