/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.arkhitekton.interaction.usecase;

import android.support.annotation.NonNull;
import universum.studios.android.arkhitekton.interaction.usecase.UseCaseRequest;
import universum.studios.android.arkhitekton.interaction.usecase.UseCaseResponse;
import universum.studios.android.arkhitekton.interaction.usecase.UseCaseResult;
import universum.studios.android.arkhitekton.util.Failure;
import universum.studios.android.arkhitekton.util.InstanceBuilder;

final class UseCaseResponseImpl<Result>
implements UseCaseResponse<Result> {
    private static final String TAG = "UseCaseResponseImpl";
    static final UseCaseResponse.Factory FACTORY = new FactoryImpl();
    private final UseCaseRequest request;
    private final Result result;
    private final Failure failure;

    UseCaseResponseImpl(@NonNull BuilderImpl<Result> builder) {
        this.request = builder.request;
        this.result = builder.result;
        this.failure = builder.failure;
    }

    @NonNull
    public final <R extends UseCaseRequest> R getRequest() {
        return (R)this.request;
    }

    public final boolean isSuccess() {
        return !this.isFailure();
    }

    @NonNull
    public Result getResult() {
        return this.result;
    }

    public final boolean isFailure() {
        return !Failure.Contract.none().equals(this.failure);
    }

    @NonNull
    public final Failure getFailure() {
        return this.failure;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(64);
        builder.append(UseCaseResponse.class.getSimpleName());
        builder.append("{request: ");
        builder.append(this.request);
        builder.append(", isSuccess: ");
        builder.append(this.isSuccess());
        builder.append(", result: ");
        builder.append(this.result);
        builder.append(", isFailure: ");
        builder.append(this.isFailure());
        builder.append(", failure: ");
        builder.append(this.failure);
        return builder.append("}").toString();
    }

    private static final class FactoryImpl
    implements UseCaseResponse.Factory {
        private FactoryImpl() {
        }

        @NonNull
        public <Result> UseCaseResponse<Result> createSuccess(@NonNull UseCaseRequest request, @NonNull Result result) {
            return new BuilderImpl<Result>(request).result(result).build();
        }

        @NonNull
        public <Result> UseCaseResponse<Result> createFailure(@NonNull UseCaseRequest request, @NonNull Failure failure) {
            return new BuilderImpl(request).failure(failure).build();
        }
    }

    static final class BuilderImpl<Result>
    implements InstanceBuilder<UseCaseResponseImpl<Result>> {
        final UseCaseRequest request;
        Result result = UseCaseResult.Contract.empty();
        Failure failure = Failure.Contract.none();

        BuilderImpl(@NonNull UseCaseRequest request) {
            this.request = request;
        }

        BuilderImpl<Result> result(@NonNull Result result) {
            this.result = result;
            return this;
        }

        BuilderImpl<Result> failure(@NonNull Failure failure) {
            this.failure = failure;
            return this;
        }

        @NonNull
        public UseCaseResponseImpl<Result> build() {
            return new UseCaseResponseImpl(this);
        }
    }
}

