/*
 * =================================================================================================
 *                             Copyright (C) 2018 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License 
 * you may obtain at
 * 
 * 		http://www.apache.org/licenses/LICENSE-2.0
 * 
 * You can redistribute, modify or publish any part of the code written within this file but as it 
 * is described in the License, the software distributed under the License is distributed on an 
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 * 
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.arkhitekton.util

/**
 * todo:
 *
 * @author Martin Albedinsky
 */
object ExecutionUtils {

    /**
     * Sleeps current execution on the actual thread for the specified duration.
     *
     * @param durationInMillis The desired duration in milliseconds to sleep the actual thread for.
     */
    @JvmStatic fun sleepFor(durationInMillis: Long) {
        try { Thread.sleep(durationInMillis) }
        catch (e: InterruptedException) { e.printStackTrace() }
    }
}