/*
 * =================================================================================================
 *                             Copyright (C) 2018 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License
 * you may obtain at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * You can redistribute, modify or publish any part of the code written within this file but as it
 * is described in the License, the software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.arkhitekton.presentation

import universum.studios.android.arkhitekton.util.InstanceBuilder
import universum.studios.android.arkhitekton.view.View

/**
 * Interface for presenters which may be used to handle presentation logic across application.
 *
 * **Note that it is recommended to not directly implement this interface as its signature may
 * change over time, but rather to inherit from its [BasePresenter] implementation.**
 *
 * @param V  Type of the view that observers the view model attached to the presenter.
 *
 * @author Martin Albedinsky
 * @since 1.0
 */
interface Presenter<in V : View<*>> {

    /*
	 * Companion ===================================================================================
	 */

    /**
     */
    companion object Contract {

        /**
         * Presenter instance which doesn't do any presentation logic, that is, it is "lazy".
         */
        internal val DUMMY: Presenter<*> = object : Presenter<View<*>> {

            /**
             */
            override fun attachView(view: View<*>) {}

            /**
             */
            override fun detachView(view: View<*>) {}

            /**
             */
            override fun destroy() {}
        }

        /**
         * todo:
         */
        fun dummy() = DUMMY
    }

    /*
     * Methods =====================================================================================
     */

    /**
     * todo:
     *
     * @param view
     */
    fun attachView(view: V)

    /**
     * todo:
     *
     * @param view
     */
    fun detachView(view: V)

    /**
     * todo:
     */
    fun destroy()

    /*
     * Inner classes ===============================================================================
     */

    /**
     * Interface for builders which may be used to build instances of [Presenter] implementations.
     *
     * @param T Type of the presenter of which instance the builder can build.
     *
     * @author Martin Albedinsky
     * @since 1.0
     */
    interface Builder<out T : Presenter<*>> : InstanceBuilder<T>
}