/*
 * =================================================================================================
 *                             Copyright (C) 2018 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License
 * you may obtain at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * You can redistribute, modify or publish any part of the code written within this file but as it
 * is described in the License, the software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.arkhitekton.handler;

import android.app.Activity;
import android.content.Intent;
import android.support.annotation.Nullable;

/**
 * todo
 *
 * @author Martin Albedinsky
 */
public interface ActivityResultHandler {

	/**
	 * Called from the activity result aware context that has received the given result <var>data</var>
	 * associated with the <var>requestCode</var>.
	 *
	 * @param requestCode Request code of the result.
	 * @param resultCode  Result code of the result. May be one of {@link Activity#RESULT_OK},
	 *                    {@link Activity#RESULT_FIRST_USER} or {@link Activity#RESULT_CANCELED}.
	 * @param data        The data of the result. May be {@code null} if no data has been delivered.
	 * @return {@code True} if the dispatched activity result has been processed by this handler,
	 * {@code false} if not and should be passed for processing to another handler or to be processed
	 * by the context itself.
	 */
	boolean handleActivityResult(int requestCode, int resultCode, @Nullable Intent data);
}