/*
 * =================================================================================================
 *                             Copyright (C) 2018 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License
 * you may obtain at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * You can redistribute, modify or publish any part of the code written within this file but as it
 * is described in the License, the software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.arkhitekton.data.model

import android.content.res.Resources
import android.support.annotation.NonNull

/**
 * Same as [ModelMapper] where this mapper interface may be used to implement model mappers which
 * require also [Resources] for their mapping logic.
 *
 * @author Martin Albedinsky
 * @since 1.0
 */
interface ResourceModelMapper<in FromModel, out ToModel> {

    /**
     * Contract for [ResourceModelMapper] element.
     */
    companion object Contract {

        /**
         * todo:
         *
         * @return
         * @param T
         */
        @NonNull fun <T> createSimpleMapper(): ResourceModelMapper<T, T> = object : ResourceModelMapper<T, T> {

            /*
             */
            override fun map(@NonNull model: T, @NonNull resources: Resources) = model
        }
    }

    /**
     * Maps the given `model` instance to the model instance of type specific for this mapper.
     *
     * **Note that if the given model is actually a collection of model instances, the transformed
     * collection should have the same count of model instances presented.**
     *
     * @param model The desired model to be mapped.
     * @param resources Application resources which may be used for mapping purpose.
     * @return New model instance type of specific for this mapper with data mapped from the given `model`.
     */
    @NonNull fun map(@NonNull model: FromModel, @NonNull resources: Resources): ToModel
}