/*
 * =================================================================================================
 *                             Copyright (C) 2018 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License
 * you may obtain at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * You can redistribute, modify or publish any part of the code written within this file but as it
 * is described in the License, the software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.arkhitekton.data.model

import android.support.annotation.NonNull

/**
 * Interface that may be used to implement binders responsible for binding of data of one model
 * instance to another one. The model instances may be of a different types and structures.
 *
 * The binding logic is a full responsibility of a specific binder implementation.
 *
 * @author Martin Albedinsky
 * @since 1.0
 */
interface ModelBinder<in FromModel, ToModel> {

    /**
     * Binds current data of the given `fromModel` instance to the given `toModel` instance.
     *
     * **Note that if the specified models are actually collections, they should have the same count
     * of model instances presented.**
     *
     * @param fromModel The desired model of which data to bind to the second model.
     * @param toModel   The desired model to which to bind data from the first model.
     * @return The second model instance with data bound from the first one.
     */
    @NonNull fun bind(@NonNull fromModel: FromModel, @NonNull toModel: ToModel): ToModel
}