/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.analytics;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.crashlytics.android.Crashlytics;
import com.crashlytics.android.answers.Answers;
import com.crashlytics.android.answers.CustomEvent;
import com.crashlytics.android.answers.LoginEvent;
import java.io.Serializable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import universum.studios.android.analytics.AnalyticsDestination;
import universum.studios.android.analytics.AnalyticsEvent;
import universum.studios.android.analytics.AnalyticsFailure;
import universum.studios.android.analytics.AnalyticsModelMapper;
import universum.studios.android.analytics.event.SignInEvent;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u0011\b\u0002\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0017J\u0012\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u00020\b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Luniversum/studios/android/analytics/FabricDestination;", "Luniversum/studios/android/analytics/AnalyticsDestination;", "crashlytics", "Lcom/crashlytics/android/Crashlytics;", "(Lcom/crashlytics/android/Crashlytics;)V", "getName", "", "logEvent", "", "event", "Luniversum/studios/android/analytics/AnalyticsEvent;", "logFailure", "failure", "Luniversum/studios/android/analytics/AnalyticsFailure;", "Companion", "Mappers", "library_release"})
public final class FabricDestination
implements AnalyticsDestination {
    private final Crashlytics crashlytics;
    @NotNull
    public static final String NAME = "FABRIC";
    @NotNull
    public static final String TAG = "FabricDestination";
    public static final Companion Companion = new Companion(null);

    @Override
    @NonNull
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    public void logEvent(@NonNull @NotNull AnalyticsEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Answers answers = this.crashlytics.answers;
        if (answers == null) {
            Log.w((String)TAG, (String)"Answers not enabled. Skipping event logging.");
            return;
        }
        AnalyticsEvent analyticsEvent = event;
        if (analyticsEvent instanceof SignInEvent) {
            answers.logLogin(Mappers.Companion.getTO_LOGIN_EVENT$library_release().map(event));
        } else {
            answers.logCustom(Mappers.Companion.getTO_CUSTOM_EVENT$library_release().map(event));
        }
    }

    @Override
    public void logFailure(@NonNull @NotNull AnalyticsFailure failure) {
        Intrinsics.checkParameterIsNotNull((Object)failure, (String)"failure");
        this.crashlytics.core.logException(Mappers.Companion.getFAILURE_TO_EXCEPTION$library_release().map(failure));
    }

    private FabricDestination(@NonNull Crashlytics crashlytics) {
        this.crashlytics = crashlytics;
    }

    public /* synthetic */ FabricDestination(@NonNull @NotNull Crashlytics crashlytics, DefaultConstructorMarker $constructor_marker) {
        this(crashlytics);
    }

    @JvmStatic
    @NonNull
    @NotNull
    public static final FabricDestination create(@NonNull @NotNull Crashlytics crashlytics) {
        return Companion.create(crashlytics);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Luniversum/studios/android/analytics/FabricDestination$Mappers;", "", "()V", "Companion", "library_release"})
    @VisibleForTesting
    public static final class Mappers {
        @NotNull
        private static final AnalyticsModelMapper<AnalyticsEvent, CustomEvent> TO_CUSTOM_EVENT;
        @NotNull
        private static final AnalyticsModelMapper<AnalyticsEvent, LoginEvent> TO_LOGIN_EVENT;
        @NotNull
        private static final AnalyticsModelMapper<AnalyticsFailure, Throwable> FAILURE_TO_EXCEPTION;
        public static final Companion Companion;

        private Mappers() {
            throw (Throwable)new UnsupportedOperationException();
        }

        static {
            Companion = new Companion(null);
            TO_CUSTOM_EVENT = new AnalyticsModelMapper<AnalyticsEvent, CustomEvent>(){

                @NonNull
                @NotNull
                public CustomEvent map(@NonNull @NotNull AnalyticsEvent event) {
                    Map<String, Serializable> attributes;
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    CustomEvent customEvent = new CustomEvent(event.getType());
                    Map<String, Serializable> map = attributes = event.getAttributes();
                    if (!map.isEmpty()) {
                        Map<String, Serializable> $receiver$iv;
                        Map<String, Serializable> map2 = $receiver$iv = attributes;
                        for (Map.Entry<String, Serializable> element$iv : map2.entrySet()) {
                            Map.Entry<String, Serializable> it = element$iv;
                            if (it.getValue() instanceof Number) {
                                Serializable serializable = it.getValue();
                                if (serializable == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
                                }
                                customEvent.putCustomAttribute(it.getKey(), (Number)serializable);
                                continue;
                            }
                            customEvent.putCustomAttribute(it.getKey(), it.getValue().toString());
                        }
                    }
                    return customEvent;
                }
            };
            TO_LOGIN_EVENT = new AnalyticsModelMapper<AnalyticsEvent, LoginEvent>(){

                @NonNull
                @NotNull
                public LoginEvent map(@NonNull @NotNull AnalyticsEvent event) {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    LoginEvent loginEvent = new LoginEvent();
                    Map<String, Serializable> attributes = event.getAttributes();
                    loginEvent.putMethod(String.valueOf(attributes.get("Method")));
                    String string = String.valueOf(attributes.get("Success"));
                    LoginEvent loginEvent2 = loginEvent;
                    boolean bl = Boolean.parseBoolean(string);
                    loginEvent2.putSuccess(bl);
                    return loginEvent;
                }
            };
            FAILURE_TO_EXCEPTION = new AnalyticsModelMapper<AnalyticsFailure, Throwable>(){

                @NonNull
                @NotNull
                public Throwable map(@NonNull @NotNull AnalyticsFailure failure) {
                    Intrinsics.checkParameterIsNotNull((Object)failure, (String)"failure");
                    return failure.getCause();
                }
            };
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\b\u00a8\u0006\u0010"}, d2={"Luniversum/studios/android/analytics/FabricDestination$Mappers$Companion;", "", "()V", "FAILURE_TO_EXCEPTION", "Luniversum/studios/android/analytics/AnalyticsModelMapper;", "Luniversum/studios/android/analytics/AnalyticsFailure;", "", "getFAILURE_TO_EXCEPTION$library_release", "()Luniversum/studios/android/analytics/AnalyticsModelMapper;", "TO_CUSTOM_EVENT", "Luniversum/studios/android/analytics/AnalyticsEvent;", "Lcom/crashlytics/android/answers/CustomEvent;", "getTO_CUSTOM_EVENT$library_release", "TO_LOGIN_EVENT", "Lcom/crashlytics/android/answers/LoginEvent;", "getTO_LOGIN_EVENT$library_release", "library_release"})
        public static final class Companion {
            @NotNull
            public final AnalyticsModelMapper<AnalyticsEvent, CustomEvent> getTO_CUSTOM_EVENT$library_release() {
                return TO_CUSTOM_EVENT;
            }

            @NotNull
            public final AnalyticsModelMapper<AnalyticsEvent, LoginEvent> getTO_LOGIN_EVENT$library_release() {
                return TO_LOGIN_EVENT;
            }

            @NotNull
            public final AnalyticsModelMapper<AnalyticsFailure, Throwable> getFAILURE_TO_EXCEPTION$library_release() {
                return FAILURE_TO_EXCEPTION;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Luniversum/studios/android/analytics/FabricDestination$Companion;", "", "()V", "NAME", "", "TAG", "create", "Luniversum/studios/android/analytics/FabricDestination;", "crashlytics", "Lcom/crashlytics/android/Crashlytics;", "library_release"})
    public static final class Companion {
        @JvmStatic
        @NonNull
        @NotNull
        public final FabricDestination create(@NonNull @NotNull Crashlytics crashlytics) {
            Intrinsics.checkParameterIsNotNull((Object)crashlytics, (String)"crashlytics");
            return new FabricDestination(crashlytics, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

