/*
 * =================================================================================================
 *                             Copyright (C) 2018 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License
 * you may obtain at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * You can redistribute, modify or publish any part of the code written within this file but as it
 * is described in the License, the software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.analytics

import android.support.annotation.NonNull

/**
 * Specifies a basic interface for an event which may be delivered to a desired destination.
 *
 * @author Martin Albedinsky
 */
interface Event {

    /*
     * Companion ===================================================================================
     */

    /*
     * Interface ===================================================================================
     */

    /**
     * Basic interface for builders which may be used to build instances of [Event] implementations.
     *
     * @param T Type of the event of which instance this builder can build.
     *
     * @author Martin Albedinsky
     */
    interface Builder<out T : Event> {

        /**
         * Builds a new instance of event specific for this builder.
         *
         * @return New instance of the desired event ready to be used.
         * @throws AssertionError If some of the required arguments is not specified.
         */
        @NonNull fun build(): T
    }

    /*
     * Methods =====================================================================================
     */

    /**
     * Returns the set of destinations where this event should be delivered.
     *
     * @return Destinations of this event.
     */
    @NonNull fun getDestinations(): Set<String>
}