/*
 * =================================================================================================
 *                             Copyright (C) 2018 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License
 * you may obtain at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * You can redistribute, modify or publish any part of the code written within this file but as it
 * is described in the License, the software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.analytics

import universum.studios.android.analytics.event.ScreenViewEvent

import android.support.annotation.NonNull

/**
 * A marking interface which may be used to mark a desired `Activity` or `Fragment` in order to
 * inform [ScreenViewAnalytics] that [ScreenViewEvent] should be logged for such component.
 *
 * @author Martin Albedinsky
 */
interface AnalyticsScreen {

    /**
     * Returns the unique name of this screen for analytics purpose only.
     *
     * @return Analytic name of this screen.
     */
    @NonNull fun getAnalyticName(): String
}