/*
 * =================================================================================================
 *                             Copyright (C) 2018 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License
 * you may obtain at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * You can redistribute, modify or publish any part of the code written within this file but as it
 * is described in the License, the software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.analytics

import android.support.annotation.NonNull

/**
 * Declaration for events that may be used to **analyze failures** occurring in an application. Each
 * analytics failure is required to provide [cause][getCause] due to which is such failure reported.
 *
 * @author Martin Albedinsky
 * @see AnalyticsEvent
 */
interface AnalyticsFailure : Event {

    /*
     * Companion ===================================================================================
     */

    /*
     * Interface ===================================================================================
     */

    /**
     * Basic interface for builders which may be used to build instances of [AnalyticsFailure] implementations.
     *
     * @param T Type of the analytics failure of which instance this builder can build.
     *
     * @author Martin Albedinsky
     */
    interface Builder<out T : AnalyticsFailure> : universum.studios.android.analytics.Event.Builder<T>

    /*
     * Methods =====================================================================================
     */

    /**
     * Returns the cause of this failure.
     *
     * @return Cause due to which has been this analytics failure created.
     */
    @NonNull fun getCause(): Throwable
}