;;   Copyright (c) Dragan Djuric. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php) or later
;;   which can be found in the file LICENSE at the root of this distribution.
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any other, from this software.

(ns ^{:author "Dragan Djuric"}
    uncomplicate.clojurecuda.protocols)

(defprotocol Mem
  "An object that represents memory that participates in CUDA operations.
  It can be on the device, or on the host.  Built-in implementations:
  cuda pointers, Java primitive arrays and ByteBuffers"
  (ptr [this] "`Pointer` to this object.")
  (size [this] "Memory size of this cuda or host object in bytes.")
  (memcpy-host* [this host size] [this host size hstream]))

(defprotocol DeviceMem
  (cu-ptr [this] "CUDA `CUdeviceptr` to this object."))

(defprotocol HostMem
  (host-ptr [this] "Host `Pointer` to this object.")
  (host-buffer [this] "The actual `ByteBuffer` on the host"))

(defprotocol ModuleLoad
  (module-load [data m])
  (module-load-jit [data m options]))

(defprotocol Contextual
  "An object that has some dependency on a `CUcontext`."
  (cu-context [this]
    "Context that is related to this object."))

(defprotocol WithOffset
  (with-offset [this ofst]))
