(ns turbovote.aws-toolbox.sqs
  (:require [cemerick.bandalore :as sqs]
            [clojure.tools.logging :refer [error]]))

(defn create-client [access-key secret-key region]
  (doto (sqs/create-client access-key
                           secret-key)
    (.setRegion region)))

(defn create-queue [client queue]
  (sqs/create-queue client queue))

(defn send-message [client queue message]
  (sqs/send client queue message))

(defn report-error [client fail-queue body error]
  (sqs/send client fail-queue
            (pr-str {:body body :error error})))

(defn safe-process [client f fail-queue]
  (fn [message]
    (try (f message)
         (catch Exception e
           (let [body (:body message)]
             (error "Failed to process" body e)
             (report-error client fail-queue body e))))))

(defn consume-messages
  [client f queue fail-queue]
  (future
    (dorun
     (map (sqs/deleting-consumer client (safe-process client f fail-queue))
          (sqs/polling-receive client queue :max-wait Long/MAX_VALUE :limit 10)))))
