(ns turbovote.aws-toolbox.s3
  (:require [aws.sdk.s3 :as s3]
            [clojure.java.io :as io]))

(defn put-object [credentials bucket key]
  (s3/put-object credentials bucket key))

(defn reader-from-s3 [key access-key secret-key bucket-name]
  (-> (s3/get-object {:access-key access-key :secret-key secret-key}
                     bucket-name
                     key)
      :content
      io/reader))
