(ns truckerpath.unilog-appenders.logentries
  (:require [unilog.config :refer [start-logging! build-appender start-appender!]]))

(defmethod build-appender :logentries
  [{:keys [token debug pattern ssl] :as config}]
  (let [appender (com.logentries.logback.LogentriesAppender.)]
    (.setDebug appender (or debug false))
    (.setToken appender token)
    (.setSsl appender (or ssl false))
    (.setSuffixPattern appender pattern)
    (let [layout (ch.qos.logback.classic.PatternLayout.)]
      (.setPattern layout pattern)
      (.setLayout appender layout))
    (assoc config :appender appender)))

(defmethod start-appender! com.logentries.logback.LogentriesAppender
  [appender context]
  (let [layout (.getLayout appender)]
    (.setContext layout context)
    (.start layout))
  (.setContext appender context)
  (.start appender))
