# clj-config [![Circle CI](https://circleci.com/gh/truckerpathteam/clj-config.svg?style=shield)](https://circleci.com/gh/truckerpathteam/clj-config)

A very simple Clojure library for loading configs from [edn files](https://github.com/edn-format/edn) with basic functions for keys look up.
Starting from version `1.0.0` config state is no longer stored by the library but has to be provided explicitly.

## Usage

[![Clojars Project](http://clojars.org/truckerpath/clj-config/latest-version.svg)](https://clojars.org/truckerpath/clj-config)

```clojure
(require '[truckerpath.clj-config.core :as cfg])

(def config (atom nil))

; Load config from file
(cfg/load! config "config.edn")

; Get  particular key
(cfg/get config "db")
(cfg/get-in config ["db" "host"])

; For more precise control over your config you can use `cfg/reset!`
(cfg/load! config "config.edn")
(cfg/reset! config (merge @config {:default :config}))
```

## License

Copyright © 2016 Trucker Path Inc.

Licensed under the [MIT License](LICENSE)
