# clj-config [![Circle CI](https://circleci.com/gh/truckerpathteam/clj-config.svg?style=shield)](https://circleci.com/gh/truckerpathteam/clj-config)

A very simple Clojure library for loading configs from [edn files](https://github.com/edn-format/edn) with basic functions for keys look up.

## Usage

[![Clojars Project](http://clojars.org/truckerpath/clj-config/latest-version.svg)](https://clojars.org/truckerpath/clj-config)

```clojure
(require '[truckerpath.clj-config.core :as cfg])

; Load config from file
(cfg/load! "config.edn")

; Get whole config
(cfg/config)

; or particular key
(cfg/get "db")
(cfg/get-in ["db" "host"])

; For more precise control over your config you can use `cfg/reset!`
(cfg/load! "config.edn")
(cfg/reset! (merge (cfg/config) {:default :config}))
```

## License

Copyright © 2016 Trucker Path Inc.

Licensed under the [MIT License](LICENSE)
