# anti-flooding-http [![Circle CI](https://circleci.com/gh/truckerpathteam/anti-flooding-http.svg?style=shield)](https://circleci.com/gh/truckerpathteam/anti-flooding-http)

A Clojure library - wrapper around [clj-http](https://github.com/dakrone/clj-http)
with one additional feature: it prevents identical simultaneous requests.

This is usefull for instance for caching services to avoid flooding backend with
identical requests prior to caching first response. Especially if backend is
kind of slow.

For instance you're making two requests `GET http://google.com` at once - only
one of them will actually be done, but both of them will block untill a response
for the first one arrive.

## Usage

[![Clojars Project](http://clojars.org/truckerpath/anti-flooding-http/latest-version.svg)](https://clojars.org/truckerpath/anti-flooding-http)

```clojure
(require '[truckerpath.anti-flooding-http.core :as http])

; Only `head` and `get` provide anti-flooding magic
(http/get "http://google.com")
(http/get "http://google.com" {:query-params {:ref "123"}})
(http/head "http://google.com")

; However the library provides wrappers around `post`, `put`, `delete`, `patch` also
(http/post "http://my.backend.com" {:body "your post data"})
(http/put "http://my.backend.com" {:body "your put data"})
```

See [clj-http](https://github.com/dakrone/clj-http) for more details.

**Two requests are considered identical if their `url`, `method` and `query-params`  are identical**.
Headers and body aren't taken into consideration.

## License

Copyright © 2016 Trucker Path Inc.

Licensed under the [MIT License](LICENSE)
