/*
 * Decompiled with CFR 0.152.
 */
package com.safframework.tony.common.utils;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public class IOUtils {
    private static final int BUFFER_SIZE = 1024;

    public static byte[] readInputStream(InputStream inStream) throws IOException {
        ByteArrayOutputStream outSteam = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            if (len == 0) continue;
            outSteam.write(buffer, 0, len);
        }
        outSteam.close();
        inStream.close();
        return outSteam.toByteArray();
    }

    public static String inputStream2String(InputStream inStream) throws IOException {
        return new String(IOUtils.readInputStream(inStream), "UTF-8");
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        int count;
        byte[] bytes = new byte[1024];
        while ((count = is.read(bytes, 0, 1024)) != -1) {
            os.write(bytes, 0, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) throws IOException {
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        FileChannel inChannel = in.getChannel();
        FileChannel outChannel = out.getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
        in.close();
        out.close();
    }

    public static void writeToFile(InputStream in, File target) throws IOException {
        int count;
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(target));
        byte[] data = new byte[1024];
        while ((count = in.read(data, 0, 1024)) != -1) {
            bos.write(data, 0, count);
        }
        bos.close();
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

