/*
 * Decompiled with CFR 0.152.
 */
package com.safframwork.tony.common.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.joda.time.DateTime;

public class JodaUtils {
    public static String getCurrentYear() {
        return new DateTime().toString("yyyy");
    }

    public static String getCurrentMonth() {
        return new DateTime().toString("MM");
    }

    public static String getCurrentDay() {
        return new DateTime().toString("dd");
    }

    public static String getCurrentHour() {
        return new DateTime().toString("HH");
    }

    public static String getCurrentMinute() {
        return new DateTime().toString("mm");
    }

    public static String getCurrentSecond() {
        return new DateTime().toString("ss");
    }

    public static String getCurrentTime() {
        return new DateTime().toString("yyyy-MM-dd HH:mm:ss");
    }

    public static String getCurrentDate() {
        return new DateTime().toString("yyyy-MM-dd");
    }

    public static Date parseDate(String strDate) {
        Date date = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            date = dateFormat.parse(strDate);
            return date;
        }
        catch (Exception pe) {
            return null;
        }
    }

    public static final Date parseDate(String strDate, String pattern) {
        SimpleDateFormat df = null;
        Date date = null;
        df = new SimpleDateFormat(pattern);
        try {
            date = df.parse(strDate);
            return date;
        }
        catch (Exception pe) {
            return null;
        }
    }

    public static final String formatDate(Date date) {
        return JodaUtils.format(date, "yyyy-MM-dd");
    }

    public static final String formatDateTime(Date date) {
        return JodaUtils.format(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static final String format(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        return new DateTime((Object)date).toString(pattern);
    }

    public static final Date addTime(Date original, int days, int hours, int minutes, int seconds) {
        if (original == null) {
            return null;
        }
        return new DateTime((Object)original).plusDays(days).plusHours(hours).plusMinutes(minutes).plusSeconds(seconds).toDate();
    }

    public static Date addYear(Date original, int years) {
        if (original == null) {
            return null;
        }
        return new DateTime((Object)original).plusYears(years).toDate();
    }

    public static Date addMonth(Date original, int months) {
        if (original == null) {
            return null;
        }
        return new DateTime((Object)original).plusMonths(months).toDate();
    }

    public static Date addWeek(Date original, int weeks) {
        if (original == null) {
            return null;
        }
        return new DateTime((Object)original).plusWeeks(weeks).toDate();
    }

    public static final Date addDay(Date original, int days) {
        if (original == null) {
            return null;
        }
        return new DateTime((Object)original).plusDays(days).toDate();
    }

    public static final Date addHour(Date original, int hours) {
        if (original == null) {
            return null;
        }
        return new DateTime((Object)original).plusHours(hours).toDate();
    }

    public static final Date addMinute(Date original, int minutes) {
        if (original == null) {
            return null;
        }
        return new DateTime((Object)original).plusMinutes(minutes).toDate();
    }

    public static final Date addSecond(Date original, int second) {
        if (original == null) {
            return null;
        }
        return new DateTime((Object)original).plusSeconds(second).toDate();
    }

    public static boolean isTomorrow(Date date) {
        if (date == null) {
            return false;
        }
        return JodaUtils.formatDate(JodaUtils.addTime(new Date(), 1, 0, 0, 0)).equals(JodaUtils.formatDate(date));
    }

    public static Date getMonthFirstDay(Date date) {
        if (date == null) {
            return null;
        }
        String dateStr = JodaUtils.format(date, "yyyy-MM") + "-01";
        return JodaUtils.parseDate(dateStr);
    }

    public static Date getMonthLastDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        String dateStr = JodaUtils.format(date, "yyyy-MM") + "-" + c.getActualMaximum(5);
        return JodaUtils.parseDate(dateStr);
    }

    public static String getDateDesc(Date time) {
        Long hour;
        if (time == null) {
            return "";
        }
        Long ss = System.currentTimeMillis() - time.getTime();
        Long minute = ss / 60000L;
        if (minute < 1L) {
            minute = 1L;
        }
        String timeContent = minute >= 60L ? ((hour = Long.valueOf(minute / 60L)) >= 24L ? (hour > 720L ? "1\u6708\u524d" : (hour > 168L && hour <= 720L ? hour / 168L + "\u5468\u524d" : hour / 24L + "\u5929\u524d")) : hour + "\u5c0f\u65f6\u524d") : minute + "\u5206\u949f\u524d";
        return timeContent;
    }

    public static boolean isLeapYear(int year) {
        if (year % 100 == 0) {
            return year % 400 == 0;
        }
        return year % 4 == 0;
    }

    public static Calendar string2Calendar(String strDate) {
        return new DateTime((Object)strDate).toCalendar(Locale.CHINA);
    }

    public static boolean compareIsBefore(Date src, Date dest, int unit) {
        if (src == null || dest == null) {
            return false;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        String srcStr = format.format(src);
        String destStr = format.format(dest);
        boolean result = false;
        switch (unit) {
            case 0: {
                if (Long.parseLong(srcStr.substring(0, 4)) >= Long.parseLong(destStr.substring(0, 4))) break;
                result = true;
                break;
            }
            case 1: {
                if (Long.parseLong(srcStr.substring(0, 6)) >= Long.parseLong(destStr.substring(0, 6))) break;
                result = true;
                break;
            }
            case 2: {
                if (Long.parseLong(srcStr.substring(0, 8)) >= Long.parseLong(destStr.substring(0, 8))) break;
                result = true;
                break;
            }
            case 3: {
                if (Long.parseLong(srcStr.substring(0, 10)) >= Long.parseLong(destStr.substring(0, 10))) break;
                result = true;
                break;
            }
            case 4: {
                if (Long.parseLong(srcStr.substring(0, 12)) >= Long.parseLong(destStr.substring(0, 12))) break;
                result = true;
                break;
            }
            case 5: {
                if (Long.parseLong(srcStr.substring(0, 14)) >= Long.parseLong(destStr.substring(0, 14))) break;
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public static String getWeek(Date date) {
        return new DateTime((Object)date).dayOfWeek().getAsText();
    }

    public static String timestamp2String(Long timestamp) {
        return JodaUtils.formatDate(new Date(timestamp));
    }

    public static String timestamp2String(Long timestamp, String pattern) {
        return JodaUtils.format(new Date(timestamp), pattern);
    }
}

