/*
 * Decompiled with CFR 0.152.
 */
package com.safframwork.tony.common.utils;

import java.util.List;
import java.util.Map;

public class Preconditions {
    public static <T> boolean isBlank(T t) {
        if (t == null) {
            return true;
        }
        if (t instanceof List) {
            if (((List)t).size() == 0) {
                return true;
            }
        } else if (t instanceof Map) {
            if (((Map)t).size() == 0) {
                return true;
            }
        } else if (t instanceof Object[]) {
            if (((Object[])t).length == 0) {
                return true;
            }
        } else if (t instanceof String) {
            String str = (String)t;
            if (str.length() == 0) {
                return true;
            }
            if ((str = str.trim()).length() == 0) {
                return true;
            }
        }
        return false;
    }

    public static <T> boolean isNotBlank(T t) {
        return !Preconditions.isBlank(t);
    }

    public static boolean isNotBlanks(Object ... objects) {
        if (objects == null) {
            return false;
        }
        for (Object obj : objects) {
            if (!Preconditions.isBlank(obj)) continue;
            return false;
        }
        return true;
    }

    public static <T> T checkNotNull(T arg) {
        return Preconditions.checkNotNull(arg, "Argument must not be null");
    }

    public static <T> T checkNotNull(T arg, String message) {
        if (arg == null) {
            throw new NullPointerException(message);
        }
        return arg;
    }
}

