package threads.share;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.util.Objects;

import threads.ipfs.IPFS;
import threads.ipfs.api.CID;

import static androidx.core.util.Preconditions.checkArgument;
import static androidx.core.util.Preconditions.checkNotNull;

public class IPFSData {
    @NonNull
    private final String multihash;
    @NonNull
    private final String key;
    @Nullable
    private final IPFS ipfs;
    private final int timeout;

    private IPFSData(@Nullable IPFS ipfs, @NonNull String multihash, @NonNull String key, int timeout) {
        checkNotNull(ipfs);
        checkNotNull(multihash);
        checkNotNull(key);
        checkArgument(timeout > 0);
        this.ipfs = ipfs;
        this.multihash = multihash;
        this.key = key;
        this.timeout = timeout;
    }

    @NonNull
    public static IPFSData create(@Nullable IPFS ipfs, @NonNull String cid, @NonNull String key, int timeout) {
        return new IPFSData(ipfs, cid, key, timeout);
    }

    @NonNull
    public static IPFSData create(@Nullable IPFS ipfs, @NonNull CID cid, @NonNull String key, int timeout) {
        return create(ipfs, cid.getCid(), key, timeout);
    }

    @NonNull
    public String getKey() {
        return key;
    }

    @Nullable
    public IPFS getIpfs() {
        return ipfs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IPFSData ipfsData = (IPFSData) o;
        return Objects.equals(multihash, ipfsData.multihash);
    }

    @Override
    public int hashCode() {
        return Objects.hash(multihash);
    }

    @NonNull
    public CID getCid() {
        return CID.create(multihash);
    }


    public int getTimeout() {
        return timeout;
    }
}
