package threads.share;

import android.provider.DocumentsContract;

import androidx.annotation.NonNull;

import threads.core.Preferences;

import static androidx.core.util.Preconditions.checkNotNull;

public class UtilityService {

    public static String getCompactString(@NonNull String title) {
        checkNotNull(title);
        return title.replace("\n", " ");
    }


    public static int getMediaResource(@NonNull String mimeType, boolean ignorePlainMimeType) {


        checkNotNull(mimeType);
        if (!mimeType.isEmpty()) {

            if (mimeType.equals(Preferences.PLAIN_MIME_TYPE)) {
                if (ignorePlainMimeType) {
                    return 0;
                } else {
                    return R.drawable.text_file;
                }
            }
            if (mimeType.equals(Preferences.PDF_MIME_TYPE)) {
                return R.drawable.text_pdf;
            }
            if (mimeType.equals(Preferences.GEO_MIME_TYPE)) {
                return R.drawable.text_map_marker;
            }
            if (mimeType.equals(DocumentsContract.Document.MIME_TYPE_DIR)) {
                return R.drawable.text_folder;
            }
            if (mimeType.equals("qr_code")) {
                return R.drawable.text_qrcode;
            }
            if (mimeType.startsWith("video")) {
                return R.drawable.text_video;
            }
            if (mimeType.startsWith("image")) {
                return R.drawable.text_camera;
            }
            if (mimeType.startsWith("audio")) {
                return R.drawable.text_audio;
            }
        }

        return R.drawable.text_file;

    }
}
