package threads.share;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.fragment.app.DialogFragment;

import static androidx.core.util.Preconditions.checkNotNull;


public class UserActionDialogFragment extends DialogFragment {
    public static final String TAG = NoteActionDialogFragment.class.getSimpleName();
    private static final String PID = "PID";
    private static final String INFO_ACTIVE = "INFO_ACTIVE";
    private static final String DELETE_ACTIVE = "DELETE_ACTIVE";
    private static final String CONNECT_ACTIVE = "CONNECT_ACTIVE";
    private static final String BLOCK_ACTIVE = "BLOCK_ACTIVE";
    private static final String EDIT_ACTIVE = "EDIT_ACTIVE";
    private static final String CALL_ACTIVE = "CALL_ACTIVE";

    private ActionListener mListener;
    private long mLastClickTime = 0;
    private Context mContext;

    public static UserActionDialogFragment newInstance(String pid,
                                                       boolean infoActive,
                                                       boolean connectActive,
                                                       boolean deleteActive,
                                                       boolean blockActive,
                                                       boolean editActive,
                                                       boolean callActive) {

        Bundle bundle = new Bundle();
        bundle.putString(PID, pid);
        bundle.putBoolean(INFO_ACTIVE, infoActive);
        bundle.putBoolean(DELETE_ACTIVE, deleteActive);
        bundle.putBoolean(CONNECT_ACTIVE, connectActive);
        bundle.putBoolean(BLOCK_ACTIVE, blockActive);
        bundle.putBoolean(EDIT_ACTIVE, editActive);
        bundle.putBoolean(CALL_ACTIVE, callActive);
        UserActionDialogFragment fragment = new UserActionDialogFragment();
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void onDetach() {
        super.onDetach();
        mContext = null;
        mListener = null;
    }

    @Override
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        mContext = context;
        try {
            mListener = (UserActionDialogFragment.ActionListener) getActivity();
        } catch (Throwable e) {
            Log.e(TAG, "" + e.getLocalizedMessage(), e);
        }
    }

    @Override
    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {

        Activity activity = getActivity();
        checkNotNull(activity);
        AlertDialog.Builder builder = new AlertDialog.Builder(mContext);

        LayoutInflater inflater = activity.getLayoutInflater();
        Bundle args = getArguments();
        checkNotNull(args);
        String pid = args.getString(PID);
        checkNotNull(pid);
        boolean infoActive = args.getBoolean(INFO_ACTIVE);
        boolean deleteActive = args.getBoolean(DELETE_ACTIVE);
        boolean blockActive = args.getBoolean(BLOCK_ACTIVE);
        boolean connectActive = args.getBoolean(CONNECT_ACTIVE);
        boolean editActive = args.getBoolean(EDIT_ACTIVE);
        boolean callActive = args.getBoolean(CALL_ACTIVE);


        @SuppressWarnings("all")
        View view = inflater.inflate(R.layout.action_user_view, null);

        TextView menu_connect = view.findViewById(R.id.menu_connect);
        if (!connectActive) {
            menu_connect.setVisibility(View.GONE);
        } else {
            menu_connect.setOnClickListener((v) -> {

                try {
                    if (SystemClock.elapsedRealtime() - mLastClickTime < 1000) {
                        return;
                    }
                    mLastClickTime = SystemClock.elapsedRealtime();
                    mListener.clickUserConnect(pid);
                } finally {
                    dismiss();
                }

            });
        }


        TextView menu_info = view.findViewById(R.id.menu_info);
        if (!infoActive) {
            menu_info.setVisibility(View.GONE);
        } else {
            menu_info.setOnClickListener((v) -> {
                try {
                    if (SystemClock.elapsedRealtime() - mLastClickTime < 1000) {
                        return;
                    }
                    mLastClickTime = SystemClock.elapsedRealtime();
                    mListener.clickUserInfo(pid);
                } finally {
                    dismiss();
                }
            });
        }

        TextView menu_edit = view.findViewById(R.id.menu_edit);
        if (!editActive) {
            menu_edit.setVisibility(View.GONE);
        } else {
            menu_edit.setOnClickListener((v) -> {

                try {
                    if (SystemClock.elapsedRealtime() - mLastClickTime < 1000) {
                        return;
                    }
                    mLastClickTime = SystemClock.elapsedRealtime();
                    mListener.clickUserEdit(pid);
                } finally {
                    dismiss();
                }
            });
        }

        TextView menu_block = view.findViewById(R.id.menu_block);
        if (!blockActive) {
            menu_block.setVisibility(View.GONE);
        } else {
            menu_block.setOnClickListener((v) -> {

                try {
                    if (SystemClock.elapsedRealtime() - mLastClickTime < 1000) {
                        return;
                    }
                    mLastClickTime = SystemClock.elapsedRealtime();
                    mListener.clickUserBlock(pid);
                } finally {
                    dismiss();
                }

            });
        }

        TextView menu_call = view.findViewById(R.id.menu_call);
        if (!callActive) {
            menu_call.setVisibility(View.GONE);
        } else {
            menu_call.setOnClickListener((v) -> {

                try {
                    if (SystemClock.elapsedRealtime() - mLastClickTime < 1000) {
                        return;
                    }
                    mLastClickTime = SystemClock.elapsedRealtime();
                    mListener.clickUserCall(pid);
                } finally {
                    dismiss();
                }
            });
        }

        TextView menu_delete = view.findViewById(R.id.menu_delete);
        if (!deleteActive) {
            menu_delete.setVisibility(View.GONE);
        } else {
            menu_delete.setOnClickListener((v) -> {

                try {
                    if (SystemClock.elapsedRealtime() - mLastClickTime < 1000) {
                        return;
                    }
                    mLastClickTime = SystemClock.elapsedRealtime();
                    mListener.clickUserDelete(pid);
                } finally {
                    dismiss();
                }
            });
        }


        builder.setView(view);
        AlertDialog dialog = builder.create();

        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        Window window = dialog.getWindow();
        if (window != null) {
            window.getAttributes().windowAnimations = R.style.DialogBottomAnimation;
            window.getAttributes().gravity = Gravity.BOTTOM | Gravity.CENTER;
            window.setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            window.setBackgroundDrawable(new ColorDrawable(android.graphics.Color.TRANSPARENT));
        }
        return dialog;
    }

    public interface ActionListener {

        void clickUserBlock(@NonNull String pid);

        void clickUserInfo(@NonNull String pid);

        void clickUserDelete(@NonNull String pid);

        void clickUserConnect(@NonNull String pid);

        void clickUserEdit(@NonNull String pid);

        void clickUserCall(@NonNull String pid);
    }
}
