package threads.share;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.CheckBox;

import androidx.annotation.NonNull;
import androidx.fragment.app.DialogFragment;

import static androidx.core.util.Preconditions.checkNotNull;

public class DontShowAgainDialog extends DialogFragment {
    public static final String TAG = DontShowAgainDialog.class.getSimpleName();
    public static final String TEXT = "TEXT";
    public static final String TITLE = "TITLE";

    public ActionListener listener;
    private Context mContext;

    @Override
    public void onDetach() {
        super.onDetach();
        listener = null;
        mContext = null;
    }


    @Override
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        mContext = context;
        try {
            listener = (DontShowAgainDialog.ActionListener) getActivity();
        } catch (Throwable e) {
            Log.e(TAG, "" + e.getLocalizedMessage(), e);
        }
    }

    @Override
    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {

        Activity activity = getActivity();
        checkNotNull(activity);

        AlertDialog.Builder builder = new AlertDialog.Builder(mContext);
        LayoutInflater inflater = activity.getLayoutInflater();

        Bundle bundle = getArguments();
        checkNotNull(bundle);
        String text = bundle.getString(TEXT);
        checkNotNull(text);
        String title = bundle.getString(TITLE);
        checkNotNull(title);

        @SuppressWarnings("all")
        View view = inflater.inflate(R.layout.checkbox, null);
        CheckBox dontShowAgain = view.findViewById(R.id.skip);

        builder.setView(view).setMessage(text)
                // Add action buttons
                .setPositiveButton(android.R.string.ok, (dialog, id) -> {

                    listener.accept(dontShowAgain.isChecked());
                    dismiss();


                })
                .setNegativeButton(android.R.string.cancel, (dialog, id) -> {
                    dismiss();

                })
                .setTitle(title);

        Dialog dialog = builder.create();
        dialog.setCanceledOnTouchOutside(false);
        Window window = dialog.getWindow();
        if (window != null) {
            window.getAttributes().windowAnimations = R.style.DialogTopAnimation;
            window.getAttributes().gravity = Gravity.TOP | Gravity.CENTER;
            window.setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        }
        return dialog;
    }

    public interface ActionListener {

        void accept(boolean dontShowAgain);

    }
}