package threads.share;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.fragment.app.DialogFragment;

import static androidx.core.util.Preconditions.checkNotNull;

public class NoteActionDialogFragment extends DialogFragment {
    public static final String TAG = NoteActionDialogFragment.class.getSimpleName();
    private static final String IDX = "IDX";
    private static final String INFO_ACTIVE = "INFO_ACTIVE";
    private static final String PUBLISH_ACTIVE = "PUBLISH_ACTIVE";
    private static final String DELETE_ACTIVE = "DELETE_ACTIVE";
    private static final String DOWNLOAD_ACTIVE = "DOWNLOAD_ACTIVE";
    private static final String CHAT_ACTIVE = "CHAT_ACTIVE";
    private static final String VIEW_ACTIVE = "VIEW_ACTIVE";

    private ActionListener actionListener;
    private long mLastClickTime = 0;

    public static NoteActionDialogFragment newInstance(long idx,
                                                       boolean infoActive,
                                                       boolean viewActive,
                                                       boolean publishActive,
                                                       boolean downloadActive,
                                                       boolean deleteActive,
                                                       boolean chatActive) {

        Bundle bundle = new Bundle();
        bundle.putLong(IDX, idx);
        bundle.putBoolean(INFO_ACTIVE, infoActive);
        bundle.putBoolean(PUBLISH_ACTIVE, publishActive);
        bundle.putBoolean(DELETE_ACTIVE, deleteActive);
        bundle.putBoolean(DOWNLOAD_ACTIVE, downloadActive);
        bundle.putBoolean(CHAT_ACTIVE, chatActive);
        bundle.putBoolean(VIEW_ACTIVE, viewActive);
        NoteActionDialogFragment fragment = new NoteActionDialogFragment();
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);

        try {
            actionListener = (ActionListener) getActivity();
        } catch (Throwable e) {
            Log.e(TAG, "" + e.getLocalizedMessage(), e);
        }
    }

    @Override
    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {

        Activity activity = getActivity();
        checkNotNull(activity);
        AlertDialog.Builder builder = new AlertDialog.Builder(activity);

        LayoutInflater inflater = activity.getLayoutInflater();
        Bundle args = getArguments();
        checkNotNull(args);
        long idx = args.getLong(IDX);
        boolean infoActive = args.getBoolean(INFO_ACTIVE);
        boolean publishActive = args.getBoolean(PUBLISH_ACTIVE);
        boolean deleteActive = args.getBoolean(DELETE_ACTIVE);
        boolean downloadActive = args.getBoolean(DOWNLOAD_ACTIVE);
        boolean chatActive = args.getBoolean(CHAT_ACTIVE);
        boolean viewActive = args.getBoolean(VIEW_ACTIVE);

        @SuppressWarnings("all")
        View view = inflater.inflate(R.layout.action_note_view, null);


        TextView menu_info = view.findViewById(R.id.menu_info);
        if (!infoActive) {
            menu_info.setVisibility(View.GONE);
        } else {
            menu_info.setOnClickListener((v) -> {
                try {
                    if (SystemClock.elapsedRealtime() - mLastClickTime < 1000) {
                        return;
                    }
                    mLastClickTime = SystemClock.elapsedRealtime();
                    actionListener.clickInfo(idx);
                } finally {
                    dismiss();
                }
            });
        }
        TextView menu_view = view.findViewById(R.id.menu_view);
        if (!viewActive) {
            menu_view.setVisibility(View.GONE);
        } else {
            menu_view.setOnClickListener((v) -> {

                try {
                    if (SystemClock.elapsedRealtime() - mLastClickTime < 1000) {
                        return;
                    }
                    mLastClickTime = SystemClock.elapsedRealtime();
                    actionListener.clickView(idx);
                } finally {
                    dismiss();
                }

            });
        }

        TextView menu_publish = view.findViewById(R.id.menu_publish);
        if (!publishActive) {
            menu_publish.setVisibility(View.GONE);
        } else {
            menu_publish.setOnClickListener((v) -> {

                try {
                    if (SystemClock.elapsedRealtime() - mLastClickTime < 1000) {
                        return;
                    }
                    mLastClickTime = SystemClock.elapsedRealtime();
                    actionListener.clickPublish(idx);
                } finally {
                    dismiss();
                }

            });
        }

        TextView menu_delete = view.findViewById(R.id.menu_delete);
        if (!deleteActive) {
            menu_delete.setVisibility(View.GONE);
        } else {
            menu_delete.setOnClickListener((v) -> {

                try {
                    if (SystemClock.elapsedRealtime() - mLastClickTime < 1000) {
                        return;
                    }
                    mLastClickTime = SystemClock.elapsedRealtime();
                    actionListener.clickDelete(idx);
                } finally {
                    dismiss();
                }
            });
        }

        TextView menu_copy = view.findViewById(R.id.menu_download);
        if (!downloadActive) {
            menu_copy.setVisibility(View.GONE);
        } else {
            menu_copy.setOnClickListener((v) -> {

                try {
                    if (SystemClock.elapsedRealtime() - mLastClickTime < 1000) {
                        return;
                    }
                    mLastClickTime = SystemClock.elapsedRealtime();
                    actionListener.clickDownload(idx);
                } finally {
                    dismiss();
                }

            });
        }

        TextView menu_chat = view.findViewById(R.id.menu_chat);
        if (!chatActive) {
            menu_chat.setVisibility(View.GONE);
        } else {
            menu_chat.setOnClickListener((v) -> {

                try {
                    if (SystemClock.elapsedRealtime() - mLastClickTime < 1000) {
                        return;
                    }
                    mLastClickTime = SystemClock.elapsedRealtime();
                    actionListener.clickChat(idx);
                } finally {
                    dismiss();
                }

            });
        }


        if (!infoActive && !viewActive && !publishActive) {
            view.findViewById(R.id.row_second).setVisibility(View.GONE);
        }

        if (!downloadActive && !chatActive && !deleteActive) {
            view.findViewById(R.id.row_first).setVisibility(View.GONE);
        }

        builder.setView(view);
        AlertDialog dialog = builder.create();

        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        Window window = dialog.getWindow();
        if (window != null) {
            window.getAttributes().windowAnimations = R.style.DialogBottomAnimation;
            window.getAttributes().gravity = Gravity.BOTTOM | Gravity.CENTER;
            window.setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            window.setBackgroundDrawable(new ColorDrawable(android.graphics.Color.TRANSPARENT));
        }
        return dialog;
    }

    public interface ActionListener {

        void clickDownload(long idx);

        void clickInfo(long idx);

        void clickDelete(long idx);

        void clickChat(long idx);

        void clickView(long idx);

        void clickPublish(long idx);
    }
}