package threads.share;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.fragment.app.DialogFragment;

import com.bumptech.glide.Glide;

import threads.core.Singleton;
import threads.ipfs.IPFS;

import static androidx.core.util.Preconditions.checkNotNull;

public class ImageDialogFragment extends DialogFragment {
    public static final String TAG = ImageDialogFragment.class.getSimpleName();
    private static final String CID = "CID";
    private static final String KEY = "KEY";
    private Context mContext;

    public static ImageDialogFragment newInstance(@NonNull String cid, @NonNull String key) {

        checkNotNull(cid);
        checkNotNull(key);
        Bundle bundle = new Bundle();

        bundle.putString(CID, cid);
        bundle.putString(KEY, key);

        ImageDialogFragment fragment = new ImageDialogFragment();
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        mContext = context;

    }

    @Override
    public void onDetach() {
        super.onDetach();
        mContext = null;
    }

    @Override
    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {

        Activity activity = getActivity();
        checkNotNull(activity);

        AlertDialog.Builder builder = new AlertDialog.Builder(mContext);

        Bundle args = getArguments();
        checkNotNull(args);
        String cid = args.getString(CID);
        checkNotNull(cid);
        String key = args.getString(KEY);
        checkNotNull(key);

        LayoutInflater inflater = activity.getLayoutInflater();


        @SuppressWarnings("all")
        View view = inflater.inflate(R.layout.image_view, null);
        ImageView mImageView = view.findViewById(R.id.image_view);

        IPFS ipfs = Singleton.getInstance(mContext).getIpfs();
        IPFSData data = IPFSData.create(ipfs, cid, key);
        Glide.with(mContext).load(data).into(mImageView);


        builder.setView(view);


        Dialog dialog = builder.create();

        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);

        return dialog;
    }
}
