package threads.ipfs;

import androidx.annotation.NonNull;

import com.google.gson.Gson;

import org.apache.commons.codec.binary.Base64;

import java.util.Map;
import java.util.Objects;


public class PubSubInfo {

    private static Gson gson = new Gson();
    @NonNull
    private final String from;
    @NonNull
    private final String data;
    @NonNull
    private final String seqno;
    @NonNull
    private final String topic;

    private PubSubInfo(@NonNull String topic, @NonNull String from, @NonNull String data, @NonNull String seqno) {
        Objects.requireNonNull(topic);
        Objects.requireNonNull(from);
        Objects.requireNonNull(data);
        Objects.requireNonNull(seqno);
        this.topic = topic;
        this.from = from;
        this.data = data;
        this.seqno = seqno;
    }

    public static PubSubInfo create(@NonNull String message, byte[] data) {
        Objects.requireNonNull(message);
        Map map = gson.fromJson(message, Map.class);
        String topic = (String) map.get("Topic");
        Objects.requireNonNull(topic);
        String from = (String) map.get("From");
        Objects.requireNonNull(from);
        String seqno = (String) map.get("Seqno");
        Objects.requireNonNull(seqno);

        String encData = new String(Base64.decodeBase64(data));

        return new PubSubInfo(topic, from, encData, seqno);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PubSubInfo that = (PubSubInfo) o;
        return Objects.equals(from, that.from) &&
                Objects.equals(data, that.data) &&
                Objects.equals(seqno, that.seqno);
    }

    @Override
    public int hashCode() {
        return Objects.hash(from, seqno);
    }

    @Override
    @NonNull
    public String toString() {
        return "{" +
                "Topic='" + getTopic() + "\' " +
                ", From='" + getSenderPid() + "\' " +
                ", Data='" + getMessage() + "\' " +
                ", Seqno='" + getSeqno() + "\' " +
                '}';
    }


    @NonNull
    public String getSenderPid() {
        return from;
    }

    @NonNull
    public String getMessage() {
        return data;
    }

    @NonNull
    public String getSeqno() {
        return seqno;
    }

    @NonNull
    public String getTopic() {
        return topic;
    }
}
