package threads.ipfs.api;

public class ExperimentalConfig {
    private boolean QUIC = false;
    private boolean P2pHttpProxy = false;
    private boolean Libp2pStreamMounting = false;
    private boolean ShardingEnabled = false;

    public boolean isStrategicProviding() {
        return StrategicProviding;
    }

    public void setStrategicProviding(boolean strategicProviding) {
        StrategicProviding = strategicProviding;
    }

    private boolean StrategicProviding = false;
    private boolean UrlstoreEnabled = false;
    private boolean FilestoreEnabled = false;
    private boolean PreferTLS = false;

    private ExperimentalConfig() {
    }

    public static ExperimentalConfig create() {
        return new ExperimentalConfig();
    }

    public boolean isPreferTLS() {
        return PreferTLS;
    }

    public void setPreferTLS(boolean preferTLS) {
        PreferTLS = preferTLS;
    }

    public boolean isP2pHttpProxy() {
        return P2pHttpProxy;
    }

    public void setP2pHttpProxy(boolean p2pHttpProxy) {
        P2pHttpProxy = p2pHttpProxy;
    }

    public boolean isLibp2pStreamMounting() {
        return Libp2pStreamMounting;
    }

    public void setLibp2pStreamMounting(boolean libp2pStreamMounting) {
        Libp2pStreamMounting = libp2pStreamMounting;
    }

    public boolean isShardingEnabled() {
        return ShardingEnabled;
    }

    public void setShardingEnabled(boolean shardingEnabled) {
        ShardingEnabled = shardingEnabled;
    }

    public boolean isUrlstoreEnabled() {
        return UrlstoreEnabled;
    }

    public void setUrlstoreEnabled(boolean urlstoreEnabled) {
        UrlstoreEnabled = urlstoreEnabled;
    }

    public boolean isFilestoreEnabled() {
        return FilestoreEnabled;
    }

    public void setFilestoreEnabled(boolean filestoreEnabled) {
        FilestoreEnabled = filestoreEnabled;
    }

    @Override
    public String toString() {
        return "ExperimentalConfig{" +
                "QUIC=" + QUIC +
                ", P2pHttpProxy=" + P2pHttpProxy +
                ", Libp2pStreamMounting=" + Libp2pStreamMounting +
                ", ShardingEnabled=" + ShardingEnabled +
                ", UrlstoreEnabled=" + UrlstoreEnabled +
                ", FilestoreEnabled=" + FilestoreEnabled +
                ", StrategicProviding=" + StrategicProviding +
                ", PreferTLS=" + PreferTLS +
                '}';
    }

    public boolean isQUIC() {
        return QUIC;
    }

    public void setQUIC(boolean QUIC) {
        this.QUIC = QUIC;
    }
}
