package threads.ipfs.api;

import java.util.ArrayList;
import java.util.HashMap;

public class SpecConfig extends HashMap<String, Object> {


    public static SpecConfig createFlatfs() {
        SpecConfig config = new SpecConfig();
        config.put("type", "mount");

        ArrayList<HashMap<String, Object>> mounts = new ArrayList<>();


        HashMap<String, Object> mountConfig = new HashMap<>();
        mountConfig.put("mountpoint", "/blocks");
        mountConfig.put("prefix", "flatfs.datastore");
        mountConfig.put("type", "measure");
        HashMap<String, Object> child = new HashMap<>();
        child.put("path", "blocks");
        child.put("shardFunc", "/repo/flatfs/shard/v1/next-to-last/2");
        child.put("sync", true);
        child.put("type", "flatfs");
        mountConfig.put("child", child);
        mounts.add(mountConfig);

        mountConfig = new HashMap<>();
        mountConfig.put("mountpoint", "/");
        mountConfig.put("prefix", "leveldb.datastore");
        mountConfig.put("type", "measure");
        child = new HashMap<>();
        child.put("compression", "none");
        child.put("path", "datastore");
        child.put("type", "levelds");

        mountConfig.put("child", child);
        mounts.add(mountConfig);
        config.put("mounts", mounts);

        return config;
    }

    public static SpecConfig createBadger() {
        SpecConfig config = new SpecConfig();
        config.put("prefix", "badger.datastore");
        config.put("type", "measure");
        HashMap<String, Object> child = new HashMap<>();
        child.put("path", "badgerds");
        child.put("syncWrites", true);
        child.put("truncate", true);
        child.put("type", "badgerds");
        config.put("child", child);

        return config;
    }

}
