package threads.ipfs.api;

import androidx.annotation.NonNull;

import static androidx.core.util.Preconditions.checkNotNull;

public class ReproviderConfig {

    @NonNull
    private StrategyEnum Strategy = StrategyEnum.all;
    @NonNull
    private String Interval = "12h";

    private ReproviderConfig() {
    }

    public static ReproviderConfig create() {
        return new ReproviderConfig();
    }

    @NonNull
    public StrategyEnum getStrategy() {
        return Strategy;
    }

    public void setStrategy(@NonNull StrategyEnum strategy) {
        checkNotNull(strategy);
        this.Strategy = strategy;
    }

    @NonNull
    public String getInterval() {
        return Interval;
    }

    public void setInterval(@NonNull String interval) {
        checkNotNull(interval);
        this.Interval = interval;
    }

    @Override
    @NonNull
    public String toString() {
        return "ReproviderConfig{" +
                "Strategy=" + Strategy +
                ", Interval='" + Interval + '\'' +
                '}';
    }

    public enum StrategyEnum {
        all, pinned, roots
    }
}
