package threads.ipfs.api;

import androidx.annotation.NonNull;

public class DatastoreConfig {

    @NonNull
    private SpecConfig Spec = SpecConfig.createFlatfs();
    @NonNull
    private String StorageMax = "10GB";
    @NonNull
    private String GCPeriod = "1h";
    private int StorageGCWatermark = 90;
    private boolean HashOnRead = false;
    private int BloomFilterSize = 0;

    public static DatastoreConfig create() {
        return new DatastoreConfig();
    }

    @Override
    public String toString() {
        return "DatastoreConfig{" +
                "Spec=" + Spec +
                ", StorageMax='" + StorageMax + '\'' +
                ", GCPeriod='" + GCPeriod + '\'' +
                ", StorageGCWatermark=" + StorageGCWatermark +
                ", HashOnRead=" + HashOnRead +
                ", BloomFilterSize=" + BloomFilterSize +
                '}';
    }

    @NonNull
    public SpecConfig getSpec() {
        return Spec;
    }

    public void setSpec(@NonNull SpecConfig spec) {
        Spec = spec;
    }

    @NonNull
    public String getStorageMax() {
        return StorageMax;
    }

    public void setStorageMax(@NonNull String storageMax) {
        StorageMax = storageMax;
    }

    @NonNull
    public String getGCPeriod() {
        return GCPeriod;
    }

    public void setGCPeriod(@NonNull String GCPeriod) {
        this.GCPeriod = GCPeriod;
    }

    public int getStorageGCWatermark() {
        return StorageGCWatermark;
    }

    public void setStorageGCWatermark(int storageGCWatermark) {
        StorageGCWatermark = storageGCWatermark;
    }

    public boolean isHashOnRead() {
        return HashOnRead;
    }

    public void setHashOnRead(boolean hashOnRead) {
        HashOnRead = hashOnRead;
    }

    public int getBloomFilterSize() {
        return BloomFilterSize;
    }

    public void setBloomFilterSize(int bloomFilterSize) {
        BloomFilterSize = bloomFilterSize;
    }
}
