package threads.ipfs.api;

import androidx.annotation.NonNull;

public class IpnsConfig {
    @NonNull
    private String RepublishPeriod = "";
    @NonNull
    private String RecordLifetime = "";
    private int ResolveCacheSize = 128;

    public static IpnsConfig create() {
        return new IpnsConfig();
    }

    @NonNull
    public String getRepublishPeriod() {
        return RepublishPeriod;
    }

    public void setRepublishPeriod(@NonNull String republishPeriod) {
        RepublishPeriod = republishPeriod;
    }

    @NonNull
    public String getRecordLifetime() {
        return RecordLifetime;
    }

    public void setRecordLifetime(@NonNull String recordLifetime) {
        RecordLifetime = recordLifetime;
    }

    public int getResolveCacheSize() {
        return ResolveCacheSize;
    }

    public void setResolveCacheSize(int resolveCacheSize) {
        ResolveCacheSize = resolveCacheSize;
    }

    @Override
    public String toString() {
        return "IpnsConfig{" +
                "RepublishPeriod='" + RepublishPeriod + '\'' +
                ", RecordLifetime='" + RecordLifetime + '\'' +
                ", ResolveCacheSize=" + ResolveCacheSize +
                '}';
    }
}
