package threads.ipfs.api;

import androidx.annotation.NonNull;

import com.google.gson.Gson;

import java.util.Map;

import static androidx.core.util.Preconditions.checkNotNull;

public class IpnsInfo {
    private static Gson gson = new Gson();
    @NonNull
    private final String name;
    @NonNull
    private final String value;

    private IpnsInfo(@NonNull String name, @NonNull String value) {
        checkNotNull(name);
        checkNotNull(value);
        this.name = name;
        this.value = value;
    }

    public static IpnsInfo create(@NonNull String json) {
        checkNotNull(json);
        Map map = gson.fromJson(json, Map.class);
        String name = (String) map.get("Name");
        checkNotNull(name);
        String value = (String) map.get("Value");
        checkNotNull(value);

        return new IpnsInfo(name, value);
    }

    @NonNull
    public String getName() {
        return name;
    }

    @NonNull
    public String getValue() {
        return value;
    }

}
