package threads.ipfs.api;

import android.util.Log;

import androidx.annotation.NonNull;

import static androidx.core.util.Preconditions.checkNotNull;

public class LogListener implements ApiListener {
    private static final String TAG = LogListener.class.getSimpleName();

    @Override
    public void info(@NonNull String message) {
        checkNotNull(message);
        Log.i(TAG, message);
    }

    @Override
    public void error(@NonNull String message) {
        checkNotNull(message);
        Log.e(TAG, message);
    }

    @Override
    public void debug(@NonNull String message) {
        checkNotNull(message);
        Log.d(TAG, message);
    }

}
