package threads.ipfs.api;

import androidx.annotation.NonNull;

public class MountsConfig {
    @NonNull
    private String IPFS = "/ipfs";
    @NonNull
    private String IPNS = "/ipns";

    private boolean FuseAllowOther = false;

    public static MountsConfig create() {
        return new MountsConfig();
    }

    @NonNull
    public String getIPFS() {
        return IPFS;
    }

    public void setIPFS(@NonNull String IPFS) {
        this.IPFS = IPFS;
    }

    @NonNull
    public String getIPNS() {
        return IPNS;
    }

    public void setIPNS(@NonNull String IPNS) {
        this.IPNS = IPNS;
    }

    @Override
    public String toString() {
        return "MountsConfig{" +
                "IPFS='" + IPFS + '\'' +
                ", IPNS='" + IPNS + '\'' +
                ", FuseAllowOther=" + FuseAllowOther +
                '}';
    }

    public boolean isFuseAllowOther() {
        return FuseAllowOther;
    }

    public void setFuseAllowOther(boolean fuseAllowOther) {
        FuseAllowOther = fuseAllowOther;
    }
}
