package threads.ipfs.api;

import androidx.annotation.NonNull;

import java.util.Map;

import static androidx.core.util.Preconditions.checkNotNull;

public class PingInfo {
    private static final String SUCCESS = "Success";
    private static final String TEXT = "Text";
    private static final String TIME = "Time";
    private final boolean success;
    private final double time;
    private final String text;


    private PingInfo(boolean success, double time, String text) {
        this.success = success;
        this.time = time;
        this.text = text;
    }

    public static PingInfo create(@NonNull Map map) {
        checkNotNull(map);
        Boolean success = (Boolean) map.get(SUCCESS);
        checkNotNull(success);
        String text = (String) map.get(TEXT);
        checkNotNull(text);
        Double time = (Double) map.get(TIME);
        checkNotNull(time);

        return new PingInfo(success, time, text);
    }

    public boolean isSuccess() {
        return success;
    }

    public double getTime() {
        return time;
    }

    public String getText() {
        return text;
    }
}
