package org.iota.jota.builder;


/**
 * Naming chosen because of preventing confusion in the code
 *
 * @param <E>
 */
@SuppressWarnings("unchecked")
public abstract class AbstractBuilder<T, E> {


    public AbstractBuilder() {

    }

    public E build() {
        try {
            generate();
        } catch (Exception e) {
            //You must know that the message comes from creating/building here, so we just log the error

            e.printStackTrace();
            return null;
        }
        return compile();
    }

    protected abstract E compile();

    protected abstract T generate() throws Exception;


}
