package threads.core.api;

import androidx.annotation.NonNull;

import com.google.gson.Gson;

import java.util.HashMap;

import threads.ipfs.api.CID;
import threads.ipfs.api.Encryption;

import static androidx.core.util.Preconditions.checkNotNull;

public class ThreadEncoder {


    @NonNull
    public static String convert(@NonNull Thread thread, @NonNull String aesKey) {
        checkNotNull(thread);
        checkNotNull(aesKey);
        Content content = new Content();
        Gson gson = new Gson();

        content.put(Content.EXPIRE_DATE, String.valueOf(thread.getExpireDate().getTime()));

        CID cid = thread.getCid();
        if (cid != null) {
            content.put(Content.CID, cid.getCid());
        }

        CID image = thread.getImage();
        if (image != null) {
            content.put(Content.IMG, image.getCid());
        }

        content.put(Content.ALIAS, thread.getSenderAlias());

        content.put(Content.SKEY, thread.getSesKey());

        content.put(Content.DATE, String.valueOf(thread.getDate().getTime()));

        HashMap<String, String> additions = thread.getExternalAdditions();
        checkNotNull(additions);
        content.put(Content.ADDS, Additionals.toString(additions));

        content.put(Content.PID, thread.getSenderPid().getPid());

        content.put(Content.PKEY, thread.getSenderKey());

        String data = gson.toJson(content);
        try {
            data = Encryption.encrypt(data, aesKey);
        } catch (Throwable e) {
            throw new RuntimeException(e);
        }

        return data;
    }
}
