package threads.core.mdl;

import android.app.Application;

import androidx.annotation.NonNull;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LiveData;

import threads.core.Preferences;
import threads.core.Singleton;
import threads.core.api.Event;
import threads.core.api.EventsDatabase;

import static androidx.core.util.Preconditions.checkNotNull;

public class EventViewModel extends AndroidViewModel {

    private final EventsDatabase eventsDatabase;

    public EventViewModel(@NonNull Application application) {
        super(application);
        eventsDatabase = Singleton.getInstance(
                application.getApplicationContext()).getEventsDatabase();
    }

    public LiveData<Event> getIPFSServerOfflineEvent() {
        return eventsDatabase.eventDao().getEvent(Preferences.IPFS_SERVER_OFFLINE_EVENT);
    }

    public LiveData<Event> getIPFSServerOnlineEvent() {
        return eventsDatabase.eventDao().getEvent(Preferences.IPFS_SERVER_ONLINE_EVENT);
    }

    public LiveData<Event> getAccountNotLoadedFailure() {
        return eventsDatabase.eventDao().getEvent(Preferences.ACCOUNT_NOT_LOADED);
    }

    public LiveData<Event> getIPFSInstallFailure() {
        return eventsDatabase.eventDao().getEvent(Preferences.IPFS_INSTALL_FAILURE);
    }

    public LiveData<Event> getIPFSStartFailure() {
        return eventsDatabase.eventDao().getEvent(Preferences.IPFS_START_FAILURE);
    }

    public LiveData<Event> getThreadSelectEvent() {
        return eventsDatabase.eventDao().getEvent(Preferences.THREAD_SELECT_EVENT);
    }

    public LiveData<Event> getUserSelectEvent() {
        return eventsDatabase.eventDao().getEvent(Preferences.USER_SELECT_EVENT);
    }

    public LiveData<Event> getNoteSelectEvent() {
        return eventsDatabase.eventDao().getEvent(Preferences.NOTE_SELECT_EVENT);
    }

    public LiveData<Event> getException() {
        return eventsDatabase.eventDao().getEvent(Preferences.EXCEPTION);
    }

    public LiveData<Event> getWarning() {
        return eventsDatabase.eventDao().getEvent(Preferences.WARNING);
    }


    public LiveData<Event> getInfo() {
        return eventsDatabase.eventDao().getEvent(Preferences.INFO);
    }

    public LiveData<Event> getEvent(@NonNull String event) {
        checkNotNull(event);
        return eventsDatabase.eventDao().getEvent(event);
    }


    public void removeEvent(@NonNull final Event event) {
        new Thread(() -> eventsDatabase.eventDao().deleteEvent(event)).start();
    }

}