package threads.core.api;

import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.google.gson.Gson;

import threads.iota.Entity;
import threads.ipfs.api.PID;

import static androidx.core.util.Preconditions.checkNotNull;

public class ServerDecoder {
    private static final String TAG = ServerDecoder.class.getSimpleName();


    @Nullable
    public static Server convert(@NonNull Entity entity, @NonNull User owner) {
        checkNotNull(entity);
        checkNotNull(owner);
        Gson gson = new Gson();
        Content content = gson.fromJson(entity.getContent(), Content.class);
        Server server = convert(content, owner.getPID());
        if (server != null) {
            server.setHash(entity.getHash());
            server.setBundle(entity.getBundle());
            server.setTimestamp(entity.getTimestamp());
        }
        return server;
    }

    @Nullable
    public static Server convert(@NonNull Content content, @NonNull PID owner) {
        checkNotNull(content);
        checkNotNull(owner);
        try {

            String protocol = content.get(Content.PROTOCOL);
            checkNotNull(protocol);
            String alias = content.get(Content.ALIAS);
            checkNotNull(alias);
            String host = content.get(Content.HOST);
            checkNotNull(host);
            String port = content.get(Content.PORT);
            checkNotNull(port);

            String additions = content.get(Content.ADDS);
            checkNotNull(additions);

            Server server = new Server(protocol, host,
                    Integer.valueOf(port), alias);
            if (!additions.isEmpty()) {
                server.setExternalAdditions(Additionals.toHashMap(additions));
            }

            return server;

        } catch (Throwable e) {
            Log.e(TAG, "" + e.getLocalizedMessage(), e);
        }
        return null;
    }
}
