package threads.core.api;

import androidx.annotation.Nullable;
import androidx.room.TypeConverter;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.ArrayList;

public class MultiAddresses extends ArrayList<String> {
    @TypeConverter
    @Nullable
    public static MultiAddresses toMultiAddresses(@Nullable String data) {
        if (data == null) {
            return null;
        }
        Gson gson = new Gson();
        Type listType = new TypeToken<MultiAddresses>() {
        }.getType();

        return gson.fromJson(data, listType);
    }

    @TypeConverter
    @Nullable
    public static String toString(@Nullable MultiAddresses addresses) {
        if (addresses == null) {
            return null;
        }
        Gson gson = new Gson();
        return gson.toJson(addresses);
    }
}
