package threads.core.api;

import androidx.room.RoomDatabase;

@androidx.room.Database(entities = {User.class,
        Thread.class, Note.class, Settings.class, Server.class, Peer.class}, version = 63, exportSchema = false)
public abstract class ThreadsDatabase extends RoomDatabase {

    public abstract PeerDao peerDao();

    public abstract UserDao userDao();

    public abstract ThreadDao threadDao();

    public abstract NoteDao noteDao();


    public abstract SettingsDao settingsDao();

    public abstract ServerDao serverDao();


    public void clear() {
        userDao().clear();
        threadDao().clear();
        noteDao().clear();
        settingsDao().clear();
        serverDao().clear();
    }

}
