package threads.core.api;

import androidx.room.RoomDatabase;

@androidx.room.Database(entities = {User.class,
        Thread.class, Note.class, BlockAccount.class,
        Settings.class, Server.class, Peer.class}, version = 62, exportSchema = false)
public abstract class ThreadsDatabase extends RoomDatabase {

    public abstract PeerDao peerDao();

    public abstract UserDao userDao();

    public abstract ThreadDao threadDao();

    public abstract NoteDao noteDao();

    public abstract BlockAccountDao blockAccountDao();

    public abstract SettingsDao settingsDao();

    public abstract ServerDao serverDao();


    public void clear() {
        userDao().clear();
        threadDao().clear();
        noteDao().clear();
        blockAccountDao().clear();
        settingsDao().clear();
        serverDao().clear();
    }

}
