package threads.core.api;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import java.util.List;

@Dao
public interface TransactionHashDao {
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insertTransitionHash(TransactionHash... hashes);


    @Query("SELECT hash FROM TransactionHash")
    List<String> getTransitionHashes();

    @Query("DELETE FROM TransactionHash")
    void clear();

    @Query("SELECT COUNT(*) FROM TransactionHash WHERE hash =:hash")
    long hasHash(String hash);

    @Query("DELETE FROM TransactionHash WHERE hash = :hash")
    void removeHash(String hash);


    @Query("DELETE FROM TransactionHash WHERE milestone <= :milestone")
    void removeAllTransitionHashWithSmallerMilestoneIndex(long milestone);

}
