/*
 * Decompiled with CFR 0.152.
 */
package thorwin.math.accelerator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Optional;
import thorwin.math.accelerator.Blas;

public final class CpuID {
    private static final boolean AVAILABLE;
    private final String vendor;
    private final int type;
    private final int family;
    private final int model;
    private final int steppingID;
    private final int brandIndex;

    public CpuID(String vendor, int type, int family, int model, int steppingID, int brandIndex) {
        this.vendor = vendor;
        this.type = type;
        this.family = family;
        this.model = model;
        this.steppingID = steppingID;
        this.brandIndex = brandIndex;
    }

    public static Optional<CpuID> getCpuID() {
        try {
            if (!AVAILABLE) {
                return Optional.empty();
            }
            int[] registers = CpuID.cpuid(0);
            byte[] vendorBytes = new byte[]{(byte)(registers[1] >> 0 & 0xFF), (byte)(registers[1] >> 8 & 0xFF), (byte)(registers[1] >> 16 & 0xFF), (byte)(registers[1] >> 24 & 0xFF), (byte)(registers[3] >> 0 & 0xFF), (byte)(registers[3] >> 8 & 0xFF), (byte)(registers[3] >> 16 & 0xFF), (byte)(registers[3] >> 24 & 0xFF), (byte)(registers[2] >> 0 & 0xFF), (byte)(registers[2] >> 8 & 0xFF), (byte)(registers[2] >> 16 & 0xFF), (byte)(registers[2] >> 24 & 0xFF)};
            String vendor = new String(vendorBytes, "US-ASCII").trim();
            registers = CpuID.cpuid(1);
            int eax = registers[0];
            int steppingID = eax & 0xF;
            int model = eax >> 4 & 0xF;
            int family = eax >> 8 & 0xF;
            int type = eax >> 12 & 3;
            int extModel = eax >> 16 & 0xF;
            int extFamily = eax >> 20 & 0xFF;
            int brandIndex = registers[1] & 0xFF;
            CpuID cpuID = new CpuID(vendor, type, family + extFamily, model + (extModel << 4), steppingID, brandIndex);
            return Optional.of(cpuID);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private static native int[] cpuid(int var0);

    public String toString() {
        return "CpuID{vendor='" + this.vendor + '\'' + ", type=" + this.type + ", family=" + this.family + ", model=" + this.model + ", steppingID=" + this.steppingID + ", brandIndex=" + this.brandIndex + '}';
    }

    public String getVendor() {
        return this.vendor;
    }

    public int getType() {
        return this.type;
    }

    public int getFamily() {
        return this.family;
    }

    public int getModel() {
        return this.model;
    }

    public int getSteppingID() {
        return this.steppingID;
    }

    public int getBrandIndex() {
        return this.brandIndex;
    }

    static {
        boolean available = true;
        try {
            String extension = ".so";
            if (System.getProperty("os.name").contains("Mac")) {
                extension = ".jnilib";
            }
            byte[] buffer = new byte[1024];
            File file = File.createTempFile("lib", extension);
            file.deleteOnExit();
            try (InputStream in = Blas.class.getResourceAsStream("CpuID" + extension);
                 FileOutputStream out = new FileOutputStream(file);){
                int len = in.read(buffer);
                while (len > 0) {
                    out.write(buffer, 0, len);
                    len = in.read(buffer);
                }
            }
            System.load(file.getAbsolutePath());
        }
        catch (IOException e) {
            available = false;
        }
        AVAILABLE = available;
    }
}

